create or replace package body tbicds.PCK_INSTRUMENT_RESPONSES is

/* Copyright 2016 Intellica Corporation.  

This software is protected by FAR Subpart 27.4 - Rights in Data and Copyrights and 
international treaties.  The software was produced by Intellica Corporation of 
San Antonio, Texas for the Veterans Administration (VA) under Contract Number 
VA118-14-C-0015, Project Number TAC-16-28335 and Project Title, 
'Traumatic Brain Injury Clinical Decision Support (TBI CDS) Implementation'.  
Contract dates: 8 May 2014 - 4 January 2016.  This software was finalized 
and uploaded to the VA's Open Source Electronic Health Record Alliance (OSEHRA) 
on 31 December 2015.  Unauthorized reproduction or distribution of this software 
or any portion of it may result in severe civil and criminal penalties and will 
be prosecuted to the maximum possible extent of the law.

For licensing information contact:  info@intellicacorp.com 
*/

  /*get an export score value given the data and a filter*/
  function fnGetExportScoreValue(pi_vDataValue  in varchar2,
                                 pi_vStatFilter in varchar2) return varchar2
  is
    v_rs              PCK_COMMON.refCursor;
    v_vSQL            varchar2(32767) := '';
    po_vResponseValue varchar2(32767) := '';

  begin
  
    v_vSQL := v_vSQL || ' select t.score_value ';
    v_vSQL := v_vSQL || '   from INTAKE_STATIC_DATA t ';
    v_vSQL := v_vSQL || '  where t.active = 1 ';
    v_vSQL := v_vSQL || '    and t.data_value = ''' || pi_vDataValue || '''';
    v_vSQL := v_vSQL || '    and ';
    v_vSQL := v_vSQL || pi_vStatFilter;
  
    open v_rs for v_vSQL;
    loop
      fetch v_rs
        into  po_vResponseValue;

      exit when v_rs%notfound;
    end loop;
    close v_rs;
    
    
    return po_vResponseValue;
  
  exception
    when others then
      return '';
  end;
  
  /* Write instrument responses to the database. */
  procedure InsertInstrumentResponse(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vPatientID     in varchar2,
                                     pi_nIntakeID      in number,
                                     pi_nMID           in number,
                                     pi_nTID           in number,
                                     pi_nQID           in number,
                                     pi_nRID           in number,
                                     pi_nScoreValue    in number,
                                     pi_vResponseValue in varchar2,
                                     
                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2)
  
   is
    v_vSQL               varchar2(4000);
    v_nResponseType      number := null;
    v_dtResponseDateTime date := sysdate;
    v_vIdentifier        varchar2(24) := null;
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
    
    --get identifier for the response
    begin
      select identifier
        into v_vIdentifier
        from intake_response t
       where t.mid = pi_nMID
         and t.tid = pi_nTID
         and t.qid = pi_nQID
         and t.rid = pi_nRID;
    exception 
      when others then
      v_vIdentifier := null;     
    end;
  
    v_vSQL := v_vSQL || ' insert into DATA_INTAKE_RESPONSES ';
    v_vSQL := v_vSQL || '  (PATIENT_ID, ';
    v_vSQL := v_vSQL || '   INTAKE_ID, ';
    v_vSQL := v_vSQL || '   RID, ';
    v_vSQL := v_vSQL || '   MID, ';
    v_vSQL := v_vSQL || '   TID, ';
    v_vSQL := v_vSQL || '   QID, ';
    v_vSQL := v_vSQL || '   RESPONSE_TYPE, ';
    v_vSQL := v_vSQL || '   RESPONSE_VALUE, ';
    v_vSQL := v_vSQL || '   SCORE_VALUE, ';
    v_vSQL := v_vSQL || '   RESPONSE_DATETIME, ';
    v_vSQL := v_vSQL || '   IDENTIFIER) ';
    v_vSQL := v_vSQL || ' values ';
    v_vSQL := v_vSQL || '   (:V_PATIENT_ID, ';
    v_vSQL := v_vSQL || '   :V_INTAKE_ID, ';
    v_vSQL := v_vSQL || '   :V_RID, ';
    v_vSQL := v_vSQL || '   :V_MID, ';
    v_vSQL := v_vSQL || '   :V_TID, ';
    v_vSQL := v_vSQL || '   :V_QID, ';
    v_vSQL := v_vSQL || '   :V_RESPONSE_TYPE, ';
    v_vSQL := v_vSQL || '   :V_RESPONSE_VALUE, ';
    v_vSQL := v_vSQL || '   :V_SCORE_VALUE, ';
    v_vSQL := v_vSQL || '   :V_RESPONSE_DATETIME, ';
    v_vSQL := v_vSQL || '   :v_vIDENTIFIER) ';
  
    --get response type from intake_response table
    begin
      select t.response_type
        into v_nResponseType
        from intake_response t
       where t.mid = pi_nMID
         and t.tid = pi_nTID
         and t.qid = pi_nQID
         and t.rid = pi_nRID;
    exception
      when others then
        v_nResponseType := null;
    end;
  
    execute immediate v_vSQL
      using pi_vPatientID, 
            pi_nIntakeID, 
            pi_nRID, 
            pi_nMID, 
            pi_nTID, 
            pi_nQID, 
            v_nResponseType, 
            pi_vResponseValue, 
            pi_nScoreValue, 
            v_dtResponseDateTime,
            v_vIdentifier;

    --AUDIT TRAIL
    v_vSQL := replace(v_vSQL, 'DATA_INTAKE_RESPONSES', 'DATA_INTAKE_RESPONSES_AUDIT');
    execute immediate v_vSQL
      using pi_vPatientID, 
            pi_nIntakeID, 
            pi_nRID, 
            pi_nMID, 
            pi_nTID, 
            pi_nQID, 
            v_nResponseType, 
            pi_vResponseValue, 
            pi_nScoreValue, 
            v_dtResponseDateTime,
            v_vIdentifier;
              
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := Sqlerrm;
  end;

  /* Get instruments responses by MID */
  procedure GetInstrumentResponsesRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vPatientID      in varchar2,
                                     --pi_nSiteID         in number,
                                     --pi_nClinicalProgID in number,
                                     --pi_nPathwayID      in number,
                                     pi_nMID            in number,
                                     pi_nIntakeID       in number,
                                     
                                     rs                out PCK_COMMON.refCursor,
                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2) 
   is
  
    v_vSQL          varchar2(4000);
    v_nLastIntakeID number := 0;
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';
  
    --v_vSQL := v_vSQL || '		select 	dr.*, ';
    v_vSQL := v_vSQL || 'select dr.PATIENT_ID,dr.INTAKE_ID,dr.RID,dr.MID,dr.TID,dr.QID,';
    v_vSQL := v_vSQL || '       dr.RESPONSE_TYPE,dr.RESPONSE_VALUE,ir.LABEL_POS,';
    v_vSQL := v_vSQL || '       case';
    v_vSQL := v_vSQL || '         when ir.display_type not in(4,22) and dr.SCORE_VALUE=0 and ir.score_value is null then ''''';
    v_vSQL := v_vSQL || '         when ir.display_type in(4,22) and dr.SCORE_VALUE=0 and ir.score_value is null and ir.stat_load_filter is null then ''''';
    v_vSQL := v_vSQL || '         when ir.display_type in(4,22) and dr.SCORE_VALUE=0 and ir.score_value is null and ir.stat_load_filter is not null then';
    v_vSQL := v_vSQL || '           pck_instrument_responses.fnGetExportScoreValue(dr.RESPONSE_VALUE, ir.stat_load_filter)';
    v_vSQL := v_vSQL || '         else to_char(dr.score_value) ';
    v_vSQL := v_vSQL || '       end as SCORE_VALUE,';
    v_vSQL := v_vSQL || '       dr.RESPONSE_DATETIME,dr.RESPONSE_TIME,dr.INTAKE_GROUP_ID,dr.IDENTIFIER,';
    v_vSQL := v_vSQL || '				im.module, ';
    v_vSQL := v_vSQL || '				it.topic, ';
    v_vSQL := v_vSQL || '				iq.question, ';
    v_vSQL := v_vSQL || '				ir.response as static_response, ';
    v_vSQL := v_vSQL || '				ir.display_type, ';
    v_vSQL := v_vSQL || '				ir.unit, ';
    v_vSQL := v_vSQL || '				di.complete_date ';
    v_vSQL := v_vSQL || '		from 	data_intake_responses dr, ';
    v_vSQL := v_vSQL || '				data_intake di, ';
    v_vSQL := v_vSQL || '				intake_module im, ';
    v_vSQL := v_vSQL || '				intake_topic it, ';
    v_vSQL := v_vSQL || '				intake_question iq, ';
    v_vSQL := v_vSQL || '				intake_response ir ';
  
    v_vSQL := v_vSQL || '		where 	dr.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '		and 	dr.mid = :MID ';
    v_vSQL := v_vSQL || '		and 	dr.intake_id = :INTAKE_ID ';
    
    --data_intake
    v_vSQL := v_vSQL || '		and di.patient_id = dr.patient_id';
    v_vSQL := v_vSQL || '		and di.intake_id = dr.intake_id';
    v_vSQL := v_vSQL || '		and di.mid = dr.mid';
  
    --intake_module
    v_vSQL := v_vSQL || '		and 	dr.mid = im.mid ';
  
    --intake_topic
    v_vSQL := v_vSQL || '		and 	dr.mid = it.mid ';
    v_vSQL := v_vSQL || '		and 	dr.tid = it.tid ';
  
    --intake_question
    v_vSQL := v_vSQL || '		and 	dr.mid = iq.mid ';
    v_vSQL := v_vSQL || '		and 	dr.tid = iq.tid ';
    v_vSQL := v_vSQL || '		and 	dr.qid = iq.qid ';
  
    --intake_response
    v_vSQL := v_vSQL || '		and 	dr.mid = ir.mid ';
    v_vSQL := v_vSQL || '		and 	dr.tid = ir.tid ';
    v_vSQL := v_vSQL || '		and 	dr.qid = ir.qid ';
    v_vSQL := v_vSQL || '		and 	dr.rid = ir.rid ';
  
    v_vSQL := v_vSQL || '		order by dr.mid, ';
    v_vSQL := v_vSQL || '				dr.tid, ';
    v_vSQL := v_vSQL || '				dr.qid, ';
    v_vSQL := v_vSQL || '				dr.rid ';
  
    -- get lats intake_id for the instrument
    begin
    
      select max(t.intake_id)
        into v_nLastIntakeID
        from data_intake_responses t
       where t.patient_id = pi_vPatientID
         and t.mid = pi_nMID;
    
    exception
      when others then
        v_nLastIntakeID := 0;
    end;
  
    --open the cursor
    open rs for v_vSQL
      using pi_vPatientID, pi_nMID, pi_nIntakeID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;
  
  /* Get merged instruments responses */
  procedure GetMergedInstrumentResponsesRS(pi_vSessionID       in varchar2,
                                     pi_vSessionClientIP in varchar2,
                                     pi_nUserID          in number,
                                     
                                     pi_vPatientID      in varchar2,
                                     pi_nMID            in number,
                                     pi_nIntakeID       in number,
                                     
                                     rs                out PCK_COMMON.refCursor,
                                     po_nStatusCode    out number,
                                     po_vStatusComment out varchar2) 
  is
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';
  
    --open recordset
    open rs for
    select *
  from (select r.mid,
               r.tid,
               r.qid,
               r.rid,
               r.identifier,
               r.response_value,
               r.score_value,
               r.response_type,
               1 as is_selected
          from data_intake_responses r
         where r.patient_id = pi_vPatientID
           and r.mid = pi_nMID
           and r.intake_id = pi_nIntakeID
        
        union
        
        select ir.mid,
               ir.tid,
               ir.qid,
               ir.rid,
               ir.identifier,
               '' as response_value,
               to_number(ir.score_value),
               ir.response_type,
               0 as is_selected
          from intake_response ir
         where ir.mid = pi_nMID
           and ir.rid not in (select r.rid
                                from data_intake_responses r
                               where r.patient_id = pi_vPatientID
                                 and r.mid = pi_nMID
                                 and r.intake_id = pi_nIntakeID)
        
        ) a
 order by mid, tid, qid, rid;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

  /* Returns a recordset with the resolved intake logic variables*/
  PROCEDURE GetIntakeLogicVarRS(pi_vSessionID       in varchar2,
                                pi_vSessionClientIP in varchar2,
                                pi_nUserID          in number,
                                pi_vPatientID       in varchar2,
                                pi_vKey             in varchar2,
                                pi_nMID             in number,
                                rs                  out PCK_COMMON.refCursor,
                                po_nStatusCode      out number,
                                po_vStatusComment   out varchar2) 
   is
  
    v_vSQL     VARCHAR2(32767) := '';
    v_vQuery   VARCHAR2(4000);
    v_count    NUMBER := 0;
    v_varvalue VARCHAR2(24);
  
  BEGIN
  
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    FOR rec IN (SELECT *
                  FROM INTAKE_LOGICVAR_SQL t
                 where t.var_id in (select var_id
                                      from intake_module_variables v
                                     where v.mid = pi_nMID)) LOOP
      IF v_count > 0 THEN
        v_vSQL := v_vSQL || ' union ';
      END IF;
      v_vQuery := REPLACE(rec.LOAD_SQL,
                          '_PATIENT_ID',
                          '''' || pi_vPatientID || '''');
      v_vQuery := REPLACE(v_vQuery, '_ENCRYPT_KEY', '''' || pi_vKey || '''');
      v_vQuery := REPLACE(v_vQuery, '_MID', pi_nMID);
      BEGIN
        EXECUTE immediate v_vQuery
          INTO v_varvalue;
      EXCEPTION
        WHEN OTHERS THEN
          v_varvalue := '';
      END;
      v_vSQL  := v_vSQL || 'select ''' || rec.VAR_ID || ''' as VAR_ID, ''' ||
                 rec.IDENTIFIER || ''' as IDENTIFIER, ''' || v_varvalue ||
                 ''' as VAR_VALUE from dual';
      v_count := v_count + 1;
    END LOOP;
    OPEN rs FOR v_vSQL;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;

  /*Get the score logic for the module*/
  procedure GetScoreLogicRS(pi_vSessionID       in varchar2,
                            pi_vSessionClientIP in varchar2,
                            pi_nUserID          in number,
                            pi_nMID             in number,
                            rs                  out PCK_COMMON.refCursor,
                            po_nStatusCode      out number,
                            po_vStatusComment   out varchar2) 
  is
  
    v_vSQL varchar2(4000);
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || '  select mid, score_logic ';
    v_vSQL := v_vSQL || '    from intake_module ';
    v_vSQL := v_vSQL || '   where active = 1 ';
    v_vSQL := v_vSQL || '     and mid = :MID ';
  
    --open the cursor
    open rs for v_vSQL
      using pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;

  /*get instruments for a patient*/
  PROCEDURE GetPatientInstrumentsRS(pi_vSessionID       IN VARCHAR2,
                                    pi_vSessionClientIP IN VARCHAR2,
                                    pi_nUserID          IN NUMBER,
                                    pi_vPatientID       IN VARCHAR2,
                                    rs                  OUT PCK_COMMON.refCursor,
                                    po_nStatusCode      OUT NUMBER,
                                    po_vStatusComment   OUT VARCHAR2) 
  is
  
  BEGIN
    po_nStatusCode    := 0;
    po_vStatusComment := '';
    --open the cursor
    OPEN rs FOR
    
      SELECT 0 AS status_id,
             'Unknown' AS status,
             t.patient_id,
             t.intake_id,
             t.mid,
             m.module,
             t.complete_date AS date_completed,
             t.score,
             '' AS interpretation,
             DECODE(t.complete, 0, 'No', 1, 'Yes') AS completed
        FROM data_intake t, intake_module m
       WHERE t.mid = m.mid
         AND t.patient_id = pi_vPatientID;
  
  EXCEPTION
    WHEN OTHERS THEN
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  END;
 
 /*****
 Remove ALL responses from previous time submitted 
 *****/
 procedure RemoveAllResponses(pi_vSessionID       in varchar2,
                              pi_vSessionClientIP in varchar2,
                              pi_nUserID          in number,
                              pi_vPatientID       in varchar2,
                              pi_nMID             in number,
                              pi_nIntakeID        in number,
                              po_nStatusCode      out number,
                              po_vStatusComment   out varchar2) 
 is
 
   v_vSQL varchar2(1000) := '';
 
 begin
   po_nStatusCode    := 0;
   po_vStatusComment := '';
   
   v_vSQL := v_vSQL || '  delete from data_intake_responses ';
   v_vSQL := v_vSQL || '    where patient_id = :pi_vPatientID ';
   v_vSQL := v_vSQL || '      and mid = :pi_nMID ';
   v_vSQL := v_vSQL || '      and intake_id = :pi_nIntakeID';
   
   execute immediate v_vSQL using pi_vPatientID, pi_nMID, pi_nIntakeID; 
   commit;
 
 exception
   when others then
     po_nStatusCode    := 1;
     po_vStatusComment := '';
 end;
 
 /*****
 Remove responses from previous time submitted
 not present in a new submittal of the instrument 
 *****/
 procedure RemovePrevResponses(pi_vSessionID       in varchar2,
                               pi_vSessionClientIP in varchar2,
                               pi_nUserID          in number,
                               pi_vPatientID       in varchar2,
                               pi_nMID             in number,
                               pi_nIntakeID        in number,
                               pi_vResponses       in varchar2,
                               po_nStatusCode      out number,
                               po_vStatusComment   out varchar2) 
 is
 
   v_vSQL varchar2(1000) := '';
 
 begin
   po_nStatusCode    := 0;
   po_vStatusComment := '';
   
   v_vSQL := v_vSQL || '  delete from data_intake_responses ';
   v_vSQL := v_vSQL || '    where patient_id = :pi_vPatientID ';
   v_vSQL := v_vSQL || '      and mid = :pi_nMID ';
   v_vSQL := v_vSQL || '      and intake_id = :pi_nIntakeID ';
   v_vSQL := v_vSQL || '      and rid not in (' || pi_vResponses || ') '; 
   
   execute immediate v_vSQL using pi_vPatientID, pi_nMID, pi_nIntakeID; 
   commit;
 
 exception
   when others then
     po_nStatusCode    := 1;
     po_vStatusComment := '';
 end;
 
 /*remove a response from an intake*/
 procedure RemoveResponse(pi_vSessionID       in varchar2,
                         pi_vSessionClientIP in varchar2,
                         pi_nUserID          in number,
                         pi_vPatientID       in varchar2,
                         pi_nMID             in number,
                         pi_nIntakeID        in number,
                         pi_nRID             in number,
                         po_nStatusCode      out number,
                         po_vStatusComment   out varchar2) 
 is
 
   v_vSQL varchar2(1000) := '';
 
 begin
   po_nStatusCode    := 0;
   po_vStatusComment := '';
   
   v_vSQL := v_vSQL || '  delete from data_intake_responses ';
   v_vSQL := v_vSQL || '    where patient_id =  :pi_vPatientID ';
   v_vSQL := v_vSQL || '      and mid = :pi_nMID ';
   v_vSQL := v_vSQL || '      and intake_id = :pi_nIntakeID ';
   v_vSQL := v_vSQL || '      and rid = :pi_nRID'; 
   
   execute immediate v_vSQL using pi_vPatientID, pi_nMID, pi_nIntakeID, pi_nRID; 
   commit;
 
 exception
   when others then
     po_nStatusCode    := 1;
     po_vStatusComment := '';
 end;
 
 /*****  
 Inserts Instruments Scores
 *****/
 procedure InsertInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID       in varchar2,
                                 pi_nIntakeID        in number,
                                 pi_nMID             in number,
                                 pi_nSeriesID        in number,
                                 pi_nScore           in number,
                                 pi_vInterpret       in varchar2,
                                     
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2)
  
   is
    v_vSQL  varchar2(4000) := '';
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || '    insert ';
    v_vSQL := v_vSQL || '       into data_intake_score s ';
    v_vSQL := v_vSQL || '         (patient_id, '; 
    v_vSQL := v_vSQL || '         mid, '; 
    v_vSQL := v_vSQL || '         intake_id, '; 
    v_vSQL := v_vSQL || '         series, '; 
    v_vSQL := v_vSQL || '         score, '; 
    v_vSQL := v_vSQL || '         interpretation) ';
    v_vSQL := v_vSQL || '       values ';
    v_vSQL := v_vSQL || '         (:PATIENT_ID, '; 
    v_vSQL := v_vSQL || '         :MID, '; 
    v_vSQL := v_vSQL || '         :INTAKE_ID, '; 
    v_vSQL := v_vSQL || '         :SERIES_ID, '; 
    v_vSQL := v_vSQL || '         :SCORE, '; 
    v_vSQL := v_vSQL || '         :INTERPRETATION) ';
  
    
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret; 
      
  --AUDIT TRAIL
  v_vSQL := replace(v_vSQL, 'data_intake_score', 'data_intake_score_audit');
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret;
  
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;
  
  /*Insert instrument score*/
  procedure InsertInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID       in varchar2,
                                 pi_nIntakeID        in number,
                                 pi_nMID             in number,
                                 pi_nSeriesID        in number,
                                 pi_nScore           in number,
                                 pi_vInterpret       in varchar2,
                                 pi_vDescription     in varchar2,
                                     
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2)
  
   is
    v_vSQL  varchar2(4000) := '';
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || '    insert ';
    v_vSQL := v_vSQL || '       into data_intake_score s ';
    v_vSQL := v_vSQL || '         (patient_id, '; 
    v_vSQL := v_vSQL || '         mid, '; 
    v_vSQL := v_vSQL || '         intake_id, '; 
    v_vSQL := v_vSQL || '         series, '; 
    v_vSQL := v_vSQL || '         score, '; 
    v_vSQL := v_vSQL || '         interpretation, ';
    v_vSQL := v_vSQL || '         description) ';
    v_vSQL := v_vSQL || '       values ';
    v_vSQL := v_vSQL || '         (:PATIENT_ID, '; 
    v_vSQL := v_vSQL || '         :MID, '; 
    v_vSQL := v_vSQL || '         :INTAKE_ID, '; 
    v_vSQL := v_vSQL || '         :SERIES_ID, '; 
    v_vSQL := v_vSQL || '         :SCORE, '; 
    v_vSQL := v_vSQL || '         :INTERPRETATION, ';
    v_vSQL := v_vSQL || '         :DESCRIPTION) ';
  
    
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret,
      pi_vDescription; 
  
  --AUDIT TRAIL
  v_vSQL := replace(v_vSQL, 'data_intake_score', 'data_intake_score_audit');
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret,
      pi_vDescription;
  
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;
  
  /*Insert instrument score*/
  procedure InsertInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID       in varchar2,
                                 pi_nIntakeID        in number,
                                 pi_nMID             in number,
                                 pi_nSeriesID        in number,
                                 pi_nScore           in number,
                                 pi_vInterpret       in varchar2,
                                 pi_vDescription     in varchar2,
                                 pi_nSeverity        in number,
                                     
                                 po_nStatusCode      out number,
                                 po_vStatusComment   out varchar2)
  
   is
    v_vSQL  varchar2(4000) := '';
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || '    insert ';
    v_vSQL := v_vSQL || '       into data_intake_score s ';
    v_vSQL := v_vSQL || '         (patient_id, '; 
    v_vSQL := v_vSQL || '         mid, '; 
    v_vSQL := v_vSQL || '         intake_id, '; 
    v_vSQL := v_vSQL || '         series, '; 
    v_vSQL := v_vSQL || '         score, '; 
    v_vSQL := v_vSQL || '         interpretation, ';
    v_vSQL := v_vSQL || '         description, ';
    v_vSQL := v_vSQL || '         severity) ';
    v_vSQL := v_vSQL || '       values ';
    v_vSQL := v_vSQL || '         (:PATIENT_ID, '; 
    v_vSQL := v_vSQL || '         :MID, '; 
    v_vSQL := v_vSQL || '         :INTAKE_ID, '; 
    v_vSQL := v_vSQL || '         :SERIES_ID, '; 
    v_vSQL := v_vSQL || '         :SCORE, '; 
    v_vSQL := v_vSQL || '         :INTERPRETATION, ';
    v_vSQL := v_vSQL || '         :DESCRIPTION, ';
    v_vSQL := v_vSQL || '         :SEVERITY) ';
  
    
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret,
      pi_vDescription,
      pi_nSeverity; 
  
  --AUDIT TRAIL
  v_vSQL := replace(v_vSQL, 'data_intake_score', 'data_intake_score_audit');
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID, 
      pi_nSeriesID, 
      pi_nScore, 
      pi_vInterpret,
      pi_vDescription,
      pi_nSeverity; 
  
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;
  
  /*****
  Delete Instrument Scores
  *****/
  procedure DeleteInstrumentScore(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP  in varchar2,
                                 pi_nUserID           in number,
                                     
                                 pi_vPatientID        in varchar2,
                                 pi_nIntakeID         in number,
                                 pi_nMID              in number,
                                     
                                 po_nStatusCode       out number,
                                 po_vStatusComment    out varchar2)
  
   is
    v_vSQL  varchar2(4000) := '';
  
  begin
    po_nStatusCode    := PCK_COMMON.c_nResultStatus_Success;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' delete ';
    v_vSQL := v_vSQL || '   from data_intake_score d ';
    v_vSQL := v_vSQL || '  where d.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '    and d.mid = :MID ';
    v_vSQL := v_vSQL || '    and d.intake_id = :INTAKE_ID ';
  
    
  execute immediate v_vSQL
      using pi_vPatientID, 
      pi_nMID, 
      pi_nIntakeID; 
  
    commit;
  
  exception
    when others then
      po_nStatusCode    := PCK_COMMON.c_nResultStatus_Error;
      po_vStatusComment := '';
  end;

  /*****
  Gets recordset of instrument score and apply filter
  *****/
  procedure GetInstrumentScoresRS(pi_vSessionID       in varchar2,
                                  pi_vSessionClientIP in varchar2,
                                  pi_nUserID          in number,
                                       
                                  pi_vPatientID       in varchar2,
                                  pi_nMID             in number,
                                  pi_nIntakeID        in number,
                                  pi_nFilter          in number,
                                       
                                  rs                  out PCK_COMMON.refCursor,
                                  po_nStatusCode      out number,
                                  po_vStatusComment   out varchar2) 
 is
    v_vSQL          varchar2(4000);
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';

 
    v_vSQL := v_vSQL || ' select * ';
    v_vSQL := v_vSQL || '   from (select t.*, ';
    v_vSQL := v_vSQL || '                im.module, ';
    v_vSQL := v_vSQL || '                m.date_completed ';
    v_vSQL := v_vSQL || '           from data_intake_score t, '; 
    v_vSQL := v_vSQL || '                pat_pw_event_module m, '; 
    v_vSQL := v_vSQL || '                intake_module im ';
    v_vSQL := v_vSQL || '          where t.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '            and t.mid = :MID ';
    v_vSQL := v_vSQL || '            and t.patient_id = m.patient_id ';
    v_vSQL := v_vSQL || '            and t.mid = m.mid ';
    v_vSQL := v_vSQL || '            and t.intake_id = m.intake_id ';
    v_vSQL := v_vSQL || '            and t.mid = im.mid(+) ';
    
    --exclude FIM goal scores, they are not real scores!
    if pi_nMID = 4042 then
    
      v_vSQL := v_vSQL || ' and ((select rid ';
      v_vSQL := v_vSQL || '         from data_intake_responses ';
      v_vSQL := v_vSQL || '        where intake_id = t.intake_id ';
      v_vSQL := v_vSQL || '          and tid=1 ';
      v_vSQL := v_vSQL || '          and qid=1 ) != 21) ';
    
    end if;                
    
    --apply filter
    case
      when pi_nFilter = 0 then v_vSQL := v_vSQL || ' ';
      when pi_nFilter = 1 then v_vSQL := v_vSQL || ' and t.intake_id <= ' || pi_nIntakeID;
      when pi_nFilter = 2 then v_vSQL := v_vSQL || ' and t.intake_id = ' || pi_nIntakeID;
      when pi_nFilter = 3 then v_vSQL := v_vSQL || ' and m.status = 2 and t.intake_id <= ' || pi_nIntakeID;
    end case;
    
    v_vSQL := v_vSQL || '            ) a ';
    v_vSQL := v_vSQL || '  order by a.mid, a.series, date_completed, intake_id ';
    
    --open the cursor
    open rs for v_vSQL
      using pi_vPatientID, pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;
  
  /*****
  Gets recordset of instrument score
  *****/
  procedure GetInstrumentScoresRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID      in varchar2,
                                 pi_nMID            in number,
                                 pi_nIntakeID       in number,
                                     
                                 rs                out PCK_COMMON.refCursor,
                                 po_nStatusCode    out number,
                                 po_vStatusComment out varchar2) 
   is
  
    v_vSQL          varchar2(4000);
    v_nLastIntakeID number := 0;
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';
  
    v_vSQL := v_vSQL || ' select t.* ';
    v_vSQL := v_vSQL || '   from DATA_INTAKE_SCORE t ';
    v_vSQL := v_vSQL || '    where t.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '    and t.mid = :MID ';
    v_vSQL := v_vSQL || '    and t.intake_id = :INTAKE_ID ';
    v_vSQL := v_vSQL || '  order by t.series ';
  

    --open the cursor
    open rs for v_vSQL
      using pi_vPatientID, pi_nMID, pi_nIntakeID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;
  
/*****
 Gets recordset of all instrument score
*****/
  
  procedure GetInstrumentScoresRS(pi_vSessionID       in varchar2,
                                 pi_vSessionClientIP in varchar2,
                                 pi_nUserID          in number,
                                     
                                 pi_vPatientID      in varchar2,
                                 pi_nMID            in number,
                                     
                                 rs                out PCK_COMMON.refCursor,
                                 po_nStatusCode    out number,
                                 po_vStatusComment out varchar2) 
  is
  
    v_vSQL          varchar2(4000);
  
  begin
    po_nStatusCode    := 0;
    po_vStatusComment := '';

 
    v_vSQL := v_vSQL || ' select * ';
    v_vSQL := v_vSQL || '   from (select t.*, ';
    v_vSQL := v_vSQL || '                im.module, ';
    v_vSQL := v_vSQL || '                m.date_completed ';
    v_vSQL := v_vSQL || '           from data_intake_score t, '; 
    v_vSQL := v_vSQL || '                pat_pw_event_module m, '; 
    v_vSQL := v_vSQL || '                intake_module im ';
    v_vSQL := v_vSQL || '          where t.patient_id = :PATIENT_ID ';
    v_vSQL := v_vSQL || '            and t.mid = :MID ';
    v_vSQL := v_vSQL || '            and t.patient_id = m.patient_id ';
    v_vSQL := v_vSQL || '            and t.mid = m.mid ';
    v_vSQL := v_vSQL || '            and t.intake_id = m.intake_id ';
    v_vSQL := v_vSQL || '            and t.mid = im.mid(+)) a ';
    v_vSQL := v_vSQL || '  order by a.mid, a.series, date_completed, intake_id ';
      
    --open the cursor
    open rs for v_vSQL
      using pi_vPatientID, pi_nMID;
  
  exception
    when others then
      po_nStatusCode    := 1;
      po_vStatusComment := '';
  end;

end PCK_INSTRUMENT_RESPONSES;
/

